-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
    
	electrics.values['mirrorR_move'] = 0
    electrics.values['mirrorR_move_input'] = 0
	electrics.values['mirrorL_move'] = 0
    electrics.values['mirrorL_move_input'] = 0
	
	
	
	

end



local function updateGFX(dt)
    
	electrics.values['mirrorR_move'] = math.min(1, math.max(0.0, (electrics.values['mirrorR_move'] + electrics.values['mirrorR_move_input'] * dt)))
	electrics.values['mirrorL_move'] = math.min(1, math.max(0.0, (electrics.values['mirrorL_move'] + electrics.values['mirrorL_move_input'] * dt)))
	
	
    
    
end



-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX

return M
